#ifndef CRYS_HASH_SEP_H
#define CRYS_HASH_SEP_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"
#include "CRYS_error.h"
#include "CRYS_Defs.h"
#include "CRYS_HASH.h"
#include "LLF_HASH_EngineInfo.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %CRYS_HASH_SEP.h    : %
   *  State           :  %state%
   *  Creation date   :  15 Apr. 2007
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains all of the enums and definitions 
   *         that are used for the CRYS HASH APIs, as well as the APIs themseleves
   *
   *  \version CRYS_HASH_SEP.h#1:incl:4
   *  \author R.Levin
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
 
/************************ Defines ******************************/


/************************ Structs  ******************************/

/************************ Public Variables **********************/

/************************ Public Functions **********************/


/************************************************************************************************/
/**
 * This function process a block of data via the HASH Hardware in SEP multi LLI mode.
 *
 * The function receives as input an handle to the  HASH Context , that was initialized before
 * by an CRYS_HASH_Init function or by other CRYS_HASH_Update function. \n
 * The function Sets the hardware with the last H's value that where stored in
 * the CRYS HASH context and then process the data block using the hardware 
 * and in the end of the process stores in the HASH context the H's value 
 * HASH Context with the cryptographic attributes that are needed for 
 * the HASH block operation ( initialize H's value for the HASH algorithm ).
 * This function is used in cases not all the data is arrange in one 
 * continues buffer . \n
 *
 * The function flow:
 *
 * 1) checking the parameters validty if there is an error the function shall exit with an error code. 
 * 2) Aquiring the working context from the CCM manager.
 * 3) If there isn't enough data in the previous update data buffer in the context plus the received data
 *    load the input data to the context buffer,  and exit the function.
 * 4) Fill the previous update data buffer from LLI table to contain an entire block and update the LLI table. 
 * 5) Calling the hardware low level function to execute the update.
 * 6) Fill the previous update data buffer with the data not processed at the end of the received data 
 *    and update the LLI table.
 * 7) Release the CCM context.
 * 
 * @param[in] ContextID_ptr - a pointer to the HASH context buffer allocated by the user that
 *                       is used for the HASH machine operation.
 * @param[in] DataInLliTab_ptr - The pointer to the buffer of LLI table, containing pointers and sizes of
 *                         chuncks of input data block. The table need to be aligned and placed in SEP SRAM.
 * @param[in] InLliTabEntries - The count of entries in the input LLI table.
 * @param[in] DataInSize  - Size of input data block in bytes. 
 *
 * @return CRYSError_t on success the function returns CRYS_OK else non ZERO error.
 *
 */
 CIMPORT_C CRYSError_t CRYS_HASH_SEP_Update(CRYS_HASHUserContext_t  *ContextID_ptr,
                                            DxUint8_t                 *intDataHead_ptr,     
	                                        DxUint32_t                intDataHeadSize, 
	                                        DxUint8_t                 *intDataTail_ptr,     
	                                        DxUint32_t                intDataTailSize, 
                                            DxUint32_t                 *DataInLliTab_ptr,     
                                            DxUint32_t                  InLliTabEntries, 
                                            DxUint32_t                  DataInSize );
                                        
                                        
/************************************************************************************************/
/**
 * This function provide HASH function to process one buffer of data in SEP multi LLI mode.
 * The function allocates an internal HASH Context , it initializes the 
 * HASH Context with the cryptographic attributes that are needed for 
 * the HASH block operation ( initialize H's value for the HASH algorithm ).
 * Then the function loads the Hardware with the initializing values and after 
 * that process the data block using the hardware to do hash .
 * At the end the function return the message digest of the data buffer .
 *
 *
 * @param[in] OperationMode - The operation mode : MD5 or SHA1.
 * @param[in] DataInLliTab_ptr - The pointer to the buffer of LLI table, containing pointers and sizes of
 *                         chuncks of input data block. The table need to be aligned and placed in SEP SRAM.
 * @param[in] InLliTabEntries - The count of entries in the input LLI table.
 * @param DataInSize  The size of the data to be hashed in bytes. 
 *
 * @retval HashResultBuff a pointer to the target buffer where the 
 *                      HASE result stored in the context is loaded to.
 *
 * @return CRYSError_t on success the function returns CRYS_OK else non ZERO error.
 *
 */
CIMPORT_C CRYSError_t CRYS_HASH_SEP( CRYS_HASH_OperationMode_t  OperationMode,
                                     DxUint32_t                *DataInLliTab_ptr,     
                                     DxUint32_t                 InLliTabEntries, 
                                     DxUint32_t                 DataInSize,
                                     CRYS_HASH_Result_t         HashResultBuff );                                        


#ifdef __cplusplus
}
#endif

#endif
